
#include "usart3.h"
u8 Usart3_Receive;

/**************************************************************************
ܣ3ʼ
ڲpclk2:PCLK2 ʱƵ(Mhz)    bound:
  ֵ
**************************************************************************/
void uart3_init(u32 pclk2,u32 bound)
{  	 
	float temp;
	u16 mantissa;
	u16 fraction;	   
	temp=(float)(pclk2*1000000)/(bound*16);//õUSARTDIV
	mantissa=temp;				 //õ
	fraction=(temp-mantissa)*16; //õС	 
  mantissa<<=4;
	mantissa+=fraction; 
	RCC->APB2ENR|=1<<3;   //ʹPORTBʱ  
	RCC->APB1ENR|=1<<18;  //ʹܴʱ 
	GPIOB->CRH&=0XFFFF00FF; 
	GPIOB->CRH|=0X00008B00;//IO״̬
	GPIOB->ODR|=1<<10;	  
	RCC->APB1RSTR|=1<<18;   //λ1
	RCC->APB1RSTR&=~(1<<18);//ֹͣλ	   	   
	//
 	USART3->BRR=mantissa; // 	 
	USART3->CR1|=0X200C;  //1λֹͣ,Уλ.
	//ʹܽж
	USART3->CR1|=1<<8;    //PEжʹ
	USART3->CR1|=1<<5;    //ջǿжʹ	    	
	MY_NVIC_Init(0,0,USART3_IRQn,2);//2
}

/**************************************************************************
ܣ3ж
ڲ
  ֵ
**************************************************************************/
void USART3_IRQHandler(void)
{	
		if(USART3->SR&(1<<5))//յ
	{	  
			static u8 Flag_PID,i,j,Receive[50];
			static float Data;
  	  Usart3_Receive=USART3->DR; 
			APP_RX=Usart3_Receive;
			if(Usart3_Receive>=0x41&&Usart3_Receive<=0x48)  
			Flag_Direction=Usart3_Receive-0x40;
			else 	if(Usart3_Receive<10)  
			Flag_Direction=Usart3_Receive;	
			else 	if(Usart3_Receive==0X5A)  
			Flag_Direction=0;	
			
				//APPԽͨѶ
		if(Usart3_Receive==0x7B) Flag_PID=1;   //APPָʼλ
		if(Usart3_Receive==0x7D) Flag_PID=2;   //APPָֹͣλ

		 if(Flag_PID==1)  //ɼ
		 {
			Receive[i]=Usart3_Receive;
			i++;
		 }
		 if(Flag_PID==2)  //
		 {
					 if(Receive[3]==0x50) 	 PID_Send=1;
					 else  if(Receive[3]==0x57) 	 Flash_Send=1;
					 else  if(Receive[1]!=0x23) 
					 {								
						for(j=i;j>=4;j--)
						{
						  Data+=(Receive[j-1]-48)*pow(10,i-j);
						}
						switch(Receive[1])
						 {
							 case 0x30:  Bluetooth_Velocity=Data;break;
							 case 0x31:  Velocity_KP=Data;break;
							 case 0x32:  Velocity_KI=Data;break;
							 case 0x33:  break;
							 case 0x34:  break;
							 case 0x35:  break;
							 case 0x36:  break;
							 case 0x37:  break; //Ԥ
							 case 0x38:  break; //Ԥ
						 }
					 }				 
					 Flag_PID=0;//ر־λ
					 i=0;
					 j=0;
					 Data=0;
					 memset(Receive, 0, sizeof(u8)*50);//
		 } 	 			
	}  											 
} 


